<?php
/*
=====================================================
 Модуль создал: REZER (http://rezer.net)
=====================================================
 Файл: rss.php
=====================================================
 Данный код защищен авторскими правами
=====================================================
 Назначение: экспорт идеи в RSS ленту
=====================================================
*/

if( !defined( "DATALIFEENGINE" ) ) die( "Hacking attempt!" );

$cat_id = $Proposal->CatIndex[ $cat ];
if( $cat_id )
	{
		if( $proposal_config['main_rss_ideas'] == "yes" )
			{
				$template_list = "";
				
				if( file_exists( ENGINE_DIR."/cache/rss_proposal_catid_{$cat_id}.tmp" ) )
					{
						$template = file_get_contents( ENGINE_DIR."/cache/rss_proposal_catid_{$cat_id}.tmp" );
					}
				
				if( !$template )
					{
						$limit = intval( $proposal_config['main_max_rss_ideas'] );
						if( $limit < 1 ) $limit = 1;
						$result = $db->query( "SELECT `id`,`title`,`description`,`alt_name`,`date`,`author` FROM ".PREFIX."_proposal_tems WHERE `approve`='1' AND `duplicate`='' AND category='{$cat_id}' ORDER BY `date` DESC LIMIT 0,{$limit}" );
						if( $db->num_rows( $result ) > 0 )
							{
								while( $row = $db->get_row( $result ) )
									{
										$id = $row['id'];
										$title = stripslashes( $row['title'] );
										$alt_name = stripslashes( $row['alt_name'] );
										$description = stripslashes( $row['description'] );
										$date = date( "r", strtotime( $row['date'] ) );
										$author = stripslashes( $row['author'] );
										
										if( $config['allow_alt_url'] == "yes" )
											{
												$link = $config['http_home_url']."proposal/{$cat}/{$id}-{$alt_name}.html";	
											}
												else
											{
												$link = $config['http_home_url']."index.php?do=proposal&cat={$cat}&tems={$id}";	
											}

$template_list .= <<<HTML
		<item>
			<title>{$title}</title>
			<guid isPermaLink="true">{$link}</guid>
			<link>{$link}</link>
			<comments>{$link}#comments</comments>
			<description><![CDATA[{$description}]]></description>
			<dc:creator>{$author}</dc:creator>
			<pubDate>{$date}</pubDate>
		</item>\n
HTML;
									}
							}
								else
							{

$template_list = <<<HTML
		<item>
			<title>Информация</title>
			<description><![CDATA[Ни одной идеи для вывода в RSS ленте не найдено.]]></description>
		</item>
HTML;

							}
						
						$title = stripslashes( $config['home_title'] );
						$link = $config['http_home_url'];
				
$template = <<<HTML
<?xml version="1.0" encoding="$config[charset]"?>
<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/">
	<channel>
		<generator>Proposal 1.0 (http://rezer.net/)</generator>
		<copyright>(C) 2009 iBlogs</copyright>
		<webMaster>rzermak@yandex.ru (REZER)</webMaster>
		<language>ru</language>
		<title>{$title}</title>
		<link>{$link}</link>
$template_list
	</channel>
</rss>
HTML;
						@unlink( ENGINE_DIR."/cache/rss_proposal_catid_{$cat_id}.tmp" );
						$fp = fopen( ENGINE_DIR."/cache/rss_proposal_catid_{$cat_id}.tmp", "w+" );
						fwrite( $fp, $template );
						fclose( $fp );
					}
				
				header( "Content-type: application/xml" );
				die( $template );
			}
				else
			{
				if( $config['allow_alt_url'] == "yes" )
					{
						$link = "/proposal/{$cat}/";	
					}
						else
					{
						$link = "/index.php?do=proposal&amp;cat={$cat}";
					}
				
				$tpl->Load_Template( "info.tpl" );
				$tpl->set( "{title}", "Информация" );
				$tpl->set( "{error}", "RSS экспорт идей в данный момент отключён, <a href=\"{$link}\">вернуться назад</a>." );
				$tpl->compile( "proposal_content" );
				$tpl->clear();
			}
	}
		else
	{
		if( $config['allow_alt_url'] == "yes" )
			{
				$link = "/proposal/";	
			}
				else
			{
				$link = "/index.php?do=proposal";
			}
		
		$tpl->Load_Template( "info.tpl" );
		$tpl->set( "{title}", "Ошибка" );
		$tpl->set( "{error}", "Не верный адрес, <a href=\"{$link}\">вернуться назад</a>." );
		$tpl->compile( "proposal_content" );
		$tpl->clear();
	}
?>